#include <Devices.h>

#ifdef __cplusplus
extern "C"{
#endif

#define ANSI					/* for CodeWarrior */

extern	short	ieee,			/* Reference number for IEEE interface */
				DevParams[],	/* Control/Status parameter block */
				state(void);	/* I/O state of interface */

extern	OSErr	MacOSErr;		/* I/O error number */
				
extern	int		ckactive(void),	/* Check for active conditions */
				_false_(void),	/* Default active condition check, always 0 */
				(*ieee_ckactive)();	/* Pointer to check routine, 
									   initially points to _false_ */

extern	void	no_op(void),		/* Function that does nothing at all */
				(*ieee_isr)();		/* Pointer to active condition service
									   routine.  Initially points to no_op */

#define	ieeerestart()	Control(ieee,256,DevParams)

extern	long	_ieeewt(short refnum, char chars[]),	/*	IEEE Write and Read routines. */
				_ieeerd(short refnum,char chars[],long size);	/*	Use macros below. */

#define ieeewt(chars)	_ieeewt(ieee,chars)
#define	ieeerd(chars)	_ieeerd(ieee,chars,sizeof(chars))

#ifdef ANSI
extern int	ieeeprtf(char *format,...);		/* IEEE versions of printf */
extern int	ieeescnf(char *format,...);		/* and scanf			   */
#else
extern int	ieeeprtf();		/* IEEE versions of printf */
extern int	ieeescnf();		/* and scanf			   */
#endif

extern	OSErr	ieeeinit(void);		/* Initialize IEEE interface */




#ifdef __cplusplus
};
#endif
