// TDR.h
// header file of TDR processing
//        by apj
#include "fileio.h"
#include "mathconst.h"
//#include "complex.h"
#include "showlist.h"
#include "TDR_meas.h"

#ifdef TDR_MAIN_PROCESS
#define SCOPE
#else
#define SCOPE extern
#endif


// common data area
#define N_DATA 4096       	// number of raw data


// common resource ID
#define TDR_MENUBAR_ID  	128

#define AppleMenuID 		128
#define TDR_MFILE_ID		129
#define TDR_MEDIT_ID		130

#define TDR_MSET_ID			131
#define TDR_MBROWS_ID		132
#define TDR_MCALC_ID		133
#define TDR_MCONN_ID		134

#define TDR_MITEM_ABOUT		1
// file
#define TDR_MITEM_NEW		1
#define TDR_MITEM_OPEN		2
#define TDR_MITEM_CLOSE		3
#define TDR_MITEM_SAVE		4
#define TDR_MITEM_SAVESET	6
#define TDR_MITEM_LOADSET	7		
#define TDR_MITEM_PRINT		9
#define TDR_MITEM_QUIT		11

// settings
#define TDR_MITEM_SPARAM	1
#define TDR_MITEM_SSAMPL	3
#define TDR_MITEM_SCALIB	4
#define TDR_MITEM_SMOREINFO	6
#define TDR_MITEM_SHOWENV	7
#define TDR_MITEM_STIMEBASE	8
// show
#define TDR_MITEM_SPREAMBL	1
#define TDR_MITEM_FTRSLT	2
#define TDR_MITEM_SSPEC		4
#define TDR_MITEM_SSTANDARD 5

// calc
#define TDR_MITEM_CCALC		1
#define TDR_MITEM_STDCALC	3

// connection
#define TDR_MITEM_MES3		1
#define TDR_MITEM_MES2		2
#define TDR_MITEM_M2M3      3
#define TDR_MITEM_M1      	4
#define TDR_MITEM_M2      	5
#define TDR_MITEM_M3      	6
#define TDR_MITEM_OP		8

#define TDR_DABOUT_ID		180
#define TDR_PARAMWIN_ID		200

// controls
#define TDR_DFILE1_ID		200
#define TDR_DFILE2_ID		201
#define TDR_DFILE3_ID		202
#define TDR_STANDARD_ID		205

// Dialog
#define TDR_RESTOREPARMS_ID	207
#define TDR_MOREINFDLG_ID	208
#define TDR_CALCDLG_ID		209
#define TDR_PREAMBLDLG_ID	210
#define TDR_ENVDLG_ID		211
#define TDR_CONVCONDDLG_ID	213
#define TDR_OPERATORDLG_ID	214
#define TDR_TIMEBASEDLG_ID	215

// Dialog items for calcdialog
#define TDR_CALC_DITEM_FREQ	5
#define TDR_CALC_DITEM_FILE	6

// alerts
#define TDR_ALERT_PRM_ID	800
#define TDR_ALERT_FREAD_ID	801
#define TDR_ALERT_CREATION_DATE	802
#define TDR_ALERT_TOOMANY_FREQ	803

// cursor
#define TDR_WAITCSR_ID		211
// Constants
#define Cv 2.9979e11		// velocity of light in mm

// get sampling interval from sampling range
#define POINTS_DIV	(double)100

// File Read Options
#define TDR_FRFLAG_NOFILE	0		// no selection
#define TDR_FRFLAG_SCS	1			// Stnadard, Cal, Sample
#define TDR_FRFLAG_SS	2			// Standard, Sample
#define TDR_FRFLAG_1D	3			// 1-data
#define TDR_FRFLAG_TOKAI 4			// Tokai Univ.format
#define TDR_FRFLAG_HP54750A_D	5	// HP54750 data
#define TDR_FRFLAG_86100B	6		// Agilent 86100B data

// File Save Options
#define TDR_FSFLAG_IGOR	1		// space delimeted text file
#define TDR_FSFLAG_TEXT	2		// Igor wave format

// File Types and Creaters
#define TDR_FTYPE		'TEXT'
#define TDR_CTYPE		'TDRS'	// Creater typs of this program
#define TDR_FIGOR		'TEXT'	// data and extra commands
#define TDR_CIGOR		'IGR0'	// Igor pro 2.X or later

// Preference file name
#define TDR_PREFSFILENAME "TDRpreference"

// Processing parameter Resource type
#define TDR_PRM_RESTYPE	'Prms'
#define TDR_PRM_RESID	200

// Environment Resorce type
#define TDR_ENV_RESTYPE 'Envs'
#define TDR_ENV_RESID	200


// EditItems resource EdtI
#define TDR_EDTI_START_ID	1200
#define TDR_EDTI_NUMBER		19
// EditItem # for time interval. Depends on EdtI resource
#define TDR_EDTI_N_TINTERVAL 8		// sampling interval
#define TDR_EDTI_N_COND_X	11		// sample conductivity
#define TDR_EDTI_N_COND_C	12		// calib. conductivity
#define TDR_EDTI_N_COMMENT	18		// comment
// start flag
#define LAUNCH_BY_DD	0		/* drag and drop */
#define LAUNCH_BY_CL	1		/* double-clicked */

// default environment
#define TDR_DEFAULT_GPIBADDR	"06"	// GPIB address of 5412*T
#define TDR_DEFAULT_OFTYPE	1			// output file type
#define TDR_DEFAULT_IFTYPE	1			// input file type


// Data Processing Parameters
typedef struct{
										// for unknown sample 
	short baseXs, baseXe;				/* start and end point of baseline */
	short cutXs, cutXe;             	/* start and end point of cutoff */
										// for calibration data
	short baseCs, baseCe;				/* start and end point of baseline */
	short cutCs, cutCe;          		/* start and end point of cutoff */

	double dt;							/* time interval(sec) */
	double d;                       	/* cell length (mm) */
	double gd;                      	/* electrical length(mm) */
	
	double gX;                      	/* conductivity */
	double gC;                      	/* conductivity */
	
	short id_standard;                 	/* index of standard sample */
	double temperature;
	
	double DCf;                     	/* frequency at DC calibration */
	
	double lfs;							/* start frequency(log) of FT */
	double lfe;							/* end frequency(log) of FT */
	double dlf;							/* frequency interval(log) */

	char comment[256];					/* comment */

	FileIO fs_dfile1;					/* data file */
	FileIO fs_dfile2;
	FileIO fs_dfile3;

	short flag_dfile1;
	short flag_dfile2;
	short flag_dfile3;
	
	FileIO fs_param;					/* parameter */
	FileIO fs_spec;				    	/* result(spectrum) */

	//options
	short limit_nit;					/* maximum number of iterarion */
	double condition_done;              /* end condition of iteration */

	
	// You can't set value directroy to the following parameters
	Boolean calibflag;				  	/* If it is true, do DC calibration */
	short 	n_rawdata;					/* data number from file */
	short   n_data;						/* data number after shift and cutoff */
	short   n_cdata;					/* for calibration */
	short	n_spec;						/* number of FT points */
	double dcx;							/* defference between baseline and end of data */
	double dcc;
	double sbex;						/* sigma / epsiron (sample) */
	double sbec;						/* sigma / epsiron (calib.) */

	// HP54750A option
	short	timebase_points;
	double	timebase_lasttime;			/* in sec. */

	// check each data has the same # of points
	short n_raw_std;					/* #of points of standard */
	short n_raw_cal;					/* #of points of DCcal */
	short n_raw_sample;					/* #of points of sample */
	
	short launch_flag;					/* launched by D&D? */

} TDR_PARAMETER, *TDR_PARAMETERPtr, **TDR_PARAMETERHandle;

// Environment
typedef struct{
	char GPIB_addr[5];
	short input_ftype;
	short output_ftype;
	// for raw data
	char rawfile_basename[64];
	char rawfile_pathname[256];  /* cannnot input */
	short rawfile_vRefNum;
	long rawfile_parID;
	short rawfile_startnum;		/* if it is negative, basename is used for exact name */
	//for processed data(dielectric spectrum)
	char spfile_basename[64];
	char spfile_pathname[256];	/* cannnot input */
	short spfile_vRefNum;
	long spfile_parID;
	short spfile_startnum;		/* if it is negative, basename is used for exact name */
	char spfile_freqbname[64];	/* for Igor wave file */
	char spfile_realbname[64];
	char spfile_imagbname[64];
	short wave_startnum;		/* if it is negative, basename is used for exact name */
	Boolean freqdup_flag;		/* if it is false, make unique name for freqency wave */
	Boolean numsave_flag;		/* if it is false, Start No is not saved */
	// memeory mapping
	short process_mmap[4];		/* RS,RB,RC,RX respectively */
	short measure_mmap[4];		/* MEM1,MEM2,MEM3,CHAN1 respectively */
	
}TDR_ENV, *TDR_ENVPtr, **TDR_ENVHandle;


//Menu
SCOPE MenuHandle applemenu, filemenu, editmenu, setmenu, browsmenu, calcmenu, connectmenu;

// for D&D passed files
SCOPE FSSpec *odoc_fss;
SCOPE long odoc_count;

// current data file
SCOPE FSSpec *current_fss;

// parameter
SCOPE EditPanel ep;
SCOPE TDR_PARAMETER tdrparam;
SCOPE PlotFormat plx;		// for sample
SCOPE PlotFormat plc;		// for calibration
SCOPE ShowList sl;
SCOPE TDR_PREAMBLE pre;
SCOPE TDR_OPINFO oinfo;
SCOPE ShowList slstd;
SCOPE TDR_ENV tdrenv;
SCOPE short GPIBAddress;
// cursor 
SCOPE CCrsrHandle WaitCurHandle;

// controls
SCOPE ControlHandle	Cdatafile1;
SCOPE ControlHandle	Cdatafile2;
SCOPE ControlHandle	Cdatafile3;
SCOPE ControlHandle	Cstandards;
SCOPE ControlHandle Cmoreinf;

// true if calcdialog displayed
SCOPE Boolean isCalcDialog;

#ifdef TDR_MAIN_PROCESS
#define TDR_NUMBER_OF_DATA N_DATA
#else
#define TDR_NUMBER_OF_DATA
#endif

// raw data
SCOPE double *TA;	// time axis
SCOPE double *RS;	// standard
SCOPE double *RB;	// standard for calobration data
SCOPE double *RC;	// calibration data
SCOPE double *RX;	// sample
SCOPE double *TAPtr, *RSPtr, *RBPtr, *RCPtr, *RXPtr; 

SCOPE double *dC;

SCOPE double *dR;
SCOPE double *Rdt;
SCOPE double *Rpp;
SCOPE double *dR_dt;		// 2001/10/23
/* for measurement only */
SCOPE double *MEM1;
SCOPE double *MEM2;
SCOPE double *MEM3;
SCOPE double *CHAN1;		// reserved
SCOPE double *MEM1Ptr, *MEM2Ptr, *MEM3Ptr, *CHAN1Ptr;
SCOPE char op_name[64];	// operator name
SCOPE char op_comment[128];	// comment for measurement
 
// after Fourier Transform
SCOPE double *fa;		// frezuency axis
SCOPE double *lfa;		// log(f) axis
SCOPE complex<double> *spect;
SCOPE double *calimag;
SCOPE short *n_it;
SCOPE complex<double> *standard_eps;

// functions
SCOPE void TDRInit(void);
SCOPE short TDRSetItems(EditItem ei[]);

SCOPE void TDR_InitContrls(WindowPtr w);
SCOPE void TDR_ControlClick(WindowPtr w,  EventRecord ev);
SCOPE void TDR_Parampopup(Point mouse, ControlHandle ctrl);
SCOPE void TDR_New(void);
SCOPE void TDR_ParamGrow(EditPanel *ep, EventRecord ev);
SCOPE void TDR_ParamZoom(EditPanel *ep, EventRecord ev);
SCOPE void TDR_SetParamToStruct(EditPanel *ep, TDR_PARAMETER *p);
SCOPE void TDR_SetParamToEditPanel(EditPanel *ep, TDR_PARAMETER *p);
SCOPE void TDR_paramerr(unsigned char *str0, unsigned char *str1, unsigned char *str2, unsigned char *str3);
SCOPE void TDR_MarkToParam(void);
SCOPE void doTDRCalc(void);
SCOPE void TDR_Setdispdata(void);
SCOPE void TDR_ShowMoreInformation(TDR_PARAMETER *pr);
SCOPE void TDR_ShowPreamble(TDR_PREAMBLE *p);
SCOPE void TDR_ClearPreamble(TDR_PREAMBLE *pr);
SCOPE Boolean TDR_ShowRestoreParmsDialog(void);
SCOPE void TDR_SetEnvironment(TDR_ENV *env);
SCOPE void TDR_RestoreMarkerPos(void);
SCOPE void TDR_StoreMarkerPosToParam(void);
SCOPE void TDR_SetItCondition(TDR_PARAMETER *pr);
SCOPE void TDR_SetOPInfo(void);
SCOPE void TDR_SetTimebase(TDR_PARAMETER *pr);

// in TDR_calc.cp
SCOPE short StartCalc(TDR_PARAMETER *pr);
SCOPE short Data_difference(double *x1, double *x2, double *x, short n);
SCOPE short Data_differentiate(double *x, double *y, double *dy, short n);
SCOPE short Data_add(double *x1, double *x2, double *x, short n);
SCOPE short Data_average(double *x, double *av, short start, short end, short n);
SCOPE short SetBaseLine(double *data, short start, short end, short n);
SCOPE short CutData(double *data, short start, short end, short n);
SCOPE short CutDataSimple(double *data, short start, short end, short n);
SCOPE complex<double> ComplexFT(double *t, double *x, short start, short end, double dt, double w);
SCOPE complex<double> Do_Iteration(complex<double> rho, double w, TDR_PARAMETER *pr, complex<double> es, short *n_it);
SCOPE complex<double> ZcotZ(double w, double d, complex<double> es);
SCOPE short CalcStandard(TDR_PARAMETER *pr);

// in TDR_file.cp
SCOPE short TDR_readDatafile(TDR_PARAMETER *pr);
SCOPE short TDR_saveSpectr(TDR_PARAMETER *pr);
SCOPE void TDR_saveParam(TDR_PARAMETER *pr);
SCOPE void write1sample(FileIO *fs, double *xa, double *data1, short n, TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);
SCOPE void write2sample(FileIO *fs, double *xa, double *data1, double *data2, short n, TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);
SCOPE void write3sample(FileIO *fs, double *xa, double *data1, double *data2, double *data3, short n, TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);
SCOPE void TDR_SavePreamble(FileIO *fs, TDR_PREAMBLE *preamble);
SCOPE short TDR_LoadPreamble(FileIO *fs, TDR_PREAMBLE *pre);
SCOPE void TDR_SaveOPInfo(FileIO *fs, TDR_OPINFO *oinfo);
SCOPE short TDR_LoadOPInfo(FileIO *fs, TDR_OPINFO *oinfo);

SCOPE short saveSpectrIgorWave(TDR_PARAMETER *pr);
SCOPE short saveSpectrDelimitedText(TDR_PARAMETER *pr);

SCOPE short TDR_GetPrefsDate(DateTimeRec *dtr);
SCOPE void TDR_SaveParmsToResouce(FSSpec *fss, TDR_PARAMETER *pr);
SCOPE Boolean TDR_QueryResourceExists(FSSpec *fss, ResType theType, short theID);
SCOPE void TDR_ReadParmsFromResouce(FSSpec *fss, TDR_PARAMETER *pr);
SCOPE short TDR_WritePrefs(TDR_PARAMETER *pr);
SCOPE short TDR_ReadPrefs(TDR_PARAMETER *pr);
SCOPE short TDR_WriteEnv(TDR_ENV *env);
SCOPE short TDR_ReadEnv(TDR_ENV *env);
SCOPE void TDR_SaveEnvToResouce(FSSpec *fss, TDR_ENV *env);
SCOPE void TDR_ReadEnvFromResouce(FSSpec *fss, TDR_ENV *env);
SCOPE void TDR_saveIcon(FileIO *fs, short id);


// in TDR_meas.cp
extern short  TDR_Get2Data(TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);
extern short  TDR_Get3Data(TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);
extern short  TDR_GetM2M3Data(TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);
extern short  TDR_Get1Data(short memindex, TDR_PREAMBLE *pre, TDR_OPINFO *oinfo);

// in TDR_auto.cp
SCOPE short TDR_AutomaticFT(FSSpec *odoc_fss, long odoc_count);
SCOPE short TDR_Process1File(FSSpec odoc_fss);

// in TDR_calcdlg.cp
SCOPE DialogPtr SetupCalcDlg(void);
SCOPE void DisposeCalcDlg(DialogPtr dlg);
SCOPE void UpdateCalcDlg(DialogPtr dlg);
SCOPE void DoCalcDlg(DialogPtr dlg, short item);
SCOPE void DoDialogEvent(EventRecord *ev);

// in TDR_about.cp
extern void TDR_About(void);


#undef SCOPE
