// TDR_Prefs.h
#ifndef TDR_PREFS_H_INCLUDED
#define TDR_PREFS_H_INCLUDED


typedef struct{
										// for unknown sample 
	short baseXs, baseXe;				/* start and end point of baseline */
	short cutXs, cutXe;             	/* start and end point of cutoff */
										// for calibration data
	short baseCs, baseCe;				/* start and end point of baseline */
	short cutCs, cutCe;          		/* start and end point of cutoff */

	double dt;							/* time interval(sec) */
	double d;                       	/* cell length (mm) */
	double gd;                      	/* electrical length(mm) */
	
	double gX;                      	/* conductivity */
	double gC;                      	/* conductivity */
	
	short id_standard;                 	/* index of standard sample */
	double temperature;
	
	double DCf;                     	/* frequency at DC calibration */
	
	double lfs;							/* start frequency(log) of FT */
	double lfe;							/* end frequency(log) of FT */
	double dlf;							/* frequency interval(log) */

	char comment[256];					/* comment */

	//options
	short limit_nit;					/* maximum number of iterarion */
	double condition_done;              /* end condition of iteration */

	// You can't set value directroy to the following parameters
	Boolean calibflag;				  	/* If it is true, do DC calibration */
	short 	n_rawdata;					/* data number from file */
	short   n_data;						/* data number after shift and cutoff */
	short   n_cdata;					/* for calibration */
	short	n_spec;						/* number of FT points */
	double dcx;							/* defference between baseline and end of data */
	double dcc;
	double sbex;						/* sigma / epsiron (sample) */
	double sbec;						/* sigma / epsiron (calib.) */

	// HP54750A option
	short	timebase_points;
	double	timebase_lasttime;			/* in sec. */

} TDR_PREFS, *TDR_PREFSPtr, **TDR_PREFSHandle;



#endif /* TDR_PREFS_H_INCLUDED */