// TDR_calcdlg.cp
// Ce[Ṽ_CAOB[hXɂ
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <Strings.h>
#include <complex.h>

#include "debugs.h"
#include "inputdialog.h"
#include "datautils.h"
#include "TDR.h"

// from TDR_calc.cp
extern char curr_fname[];
extern double curr_freq;
extern Boolean cancelled;


DialogPtr SetupCalcDlg(void)
{
	DialogPtr dlg;
	CursHandle curh;
	
	curh = GetCursor(watchCursor);
	SetCursor(*curh);
	
	dlg = GetNewDialog(TDR_CALCDLG_ID, nil, (WindowPtr)-1);
	SetPort(dlg);

	isCalcDialog = true;
	
	DisableItem(GetMenuHandle(AppleMenuID),0);
	DisableItem(GetMenuHandle(TDR_MFILE_ID),0);
	DisableItem(GetMenuHandle(TDR_MEDIT_ID),0);
	DisableItem(GetMenuHandle(TDR_MSET_ID),0);
	DisableItem(GetMenuHandle(TDR_MBROWS_ID),0);
	DisableItem(GetMenuHandle(TDR_MCALC_ID),0);
	DisableItem(GetMenuHandle(TDR_MCONN_ID),0);

	DrawMenuBar();
	
	FlushEvents(mDownMask,0);
	
	return dlg;
}

void DisposeCalcDlg(DialogPtr dlg)
{

	DisposeDialog(dlg);
	
	EnableItem(GetMenuHandle(AppleMenuID),0);
	EnableItem(GetMenuHandle(TDR_MFILE_ID),0);
	EnableItem(GetMenuHandle(TDR_MEDIT_ID),0);
	EnableItem(GetMenuHandle(TDR_MSET_ID),0);
	EnableItem(GetMenuHandle(TDR_MBROWS_ID),0);
	EnableItem(GetMenuHandle(TDR_MCALC_ID),0);
	EnableItem(GetMenuHandle(TDR_MCONN_ID),0);
	DrawMenuBar();
	isCalcDialog = false;
	
	InitCursor();
}

void UpdateCalcDlg(DialogPtr dlg)
{
	short itemtype;
	Rect box;
	Handle itemH;
	char strlf[64];
	
	GetDialogItem(dlg, TDR_CALC_DITEM_FREQ, &itemtype, &itemH, &box);
	sprintf(strlf, "%5.3e", curr_freq);
	SetDialogItemText(itemH, C2PStr(strlf));

	GetDialogItem(dlg, TDR_CALC_DITEM_FILE, &itemtype, &itemH, &box);
	SetDialogItemText(itemH, C2PStr(curr_fname));

	DrawDialog(dlg);
}

void DoCalcDlg(DialogPtr dlg, short item)
{
	SetPort(dlg);

	if(item == 1){		// cancel.
		DisposeCalcDlg(dlg);
		cancelled = true;
	}
}


void DoDialogEvent(EventRecord *ev)
{
	DialogPtr evdlg;
	Boolean needDEv = true;
	short item;
	
	switch(ev->what){
		case keyDown:
			if(((ev->message & charCodeMask) == 0x2e)	// period
				&& ((ev->modifiers & cmdKey) != 0)){	// command
				evdlg = (DialogPtr)FrontWindow();
				DoCalcDlg(evdlg, 1);	// cancel
				needDEv = false;
			}
			break;
		case updateEvt:
			UpdateCalcDlg((DialogPtr)ev->message);
			break;
	}
	if(needDEv){
		if(DialogSelect(ev, &evdlg, &item)){
			DoCalcDlg(evdlg, item);
		}
	}
}
