/* TDR_meas.h */
/* This header file is for C language, not for C++ */
/* by apj */

#ifndef TDR_MEAS_H_INCLUDED
#define TDR_MEAS_H_INCLUDED

#define L_GPIBBUF	128
#define N_GPIBDATA	4096

#define CR	0x0d
#define LF	0x0a

typedef struct{
	short format;
	short type;
	short points;
	short count;
	double xincrement;
	double xorigin;
	double xreference;
	double yincrement;
	double yorigin;
	double yreference;
	double yrange;
} TDR_PREAMBLE, *TDR_PREAMBLEPtr, **TDR_PREAMBLEHandle;

#define preambleType 'preR'
#define preambleID		200

// Operation information
typedef struct{
	char operator_name[64];
	char operation_comment[128];
	char acquisition_time[64];
	char processing_time[64];
}TDR_OPINFO, *TDR_OPINFOPtr, **TDR_OPINFOHandle;

#define TDR_OPINFO_RESTYPE 'OINF'
#define TDR_OPINFO_RESID	200

#endif /* TDR_MEAS_H_INCLUDED */