// checksys.cp
// Original Program : THINK C, Masayuki NII, BNN(1994)
// customized by apj.
#define CHECKSYS_SRC

#include "checksys.h"


Boolean	availGWorld(void)
{
	OSErr	er;
	long	myF;
	
	if(!GestaltAvailable())
		return(false);
	
	er = Gestalt(gestaltQuickdrawVersion, &myF);
	if(er!=noErr)	{}
	if(myF<gestalt32BitQD)
		return(false);
	else
		return(true);
}

Boolean	isSFSpec(void)
{
	OSErr	er;
	long	myF;
	
	if(!GestaltAvailable())
		return(false);
	
	er = Gestalt(gestaltFSAttr, &myF);
	if(er!=noErr)	{}
	if(!BitTst(&myF,31-gestaltHasFSSpecCalls))
		return(false);
	else
		return(true);
}

Boolean	isStandardFile(void)
{
	OSErr	er;
	long	myF;

	if(!GestaltAvailable())
		return(false);
	
	er = Gestalt(gestaltStandardFileAttr, &myF);
	if(er!=noErr)	{}
	if(!BitTst(&myF,31-gestaltStandardFile58))
		return(false);
	else
		return(true);
}

Boolean isSystem7(void)
{
	OSErr	er;
	long	myF;

	if(!GestaltAvailable())
		return(false);
	
	er = Gestalt(gestaltSystemVersion, &myF);
	if(er!=noErr)	{}
	if(myF<0x0700)
		return(false);
	else
		return(true);
}

long	CheckEnvLang(void)
{
	long	vb;
	vb = GetScriptManagerVariable(smSysScript);
	if(vb == smJapanese)
		return(vb);
	else
		return(smRoman);
}

#define	_InitGraf	0xa86e
#define	_Gestalt	0xa1ad
#define	TrapMask	0x0800
#define	_Unimplemented	0xaa6e

int	NumToolboxTraps(void)
{
	if(NGetTrapAddress(_InitGraf, ToolTrap) 
		== NGetTrapAddress(0xaa6e, ToolTrap))
			return(0x200);
	else
			return(0x400);
}

TrapType	GetTrapType(int	theTrap)
{
	if((theTrap&TrapMask) > 0)
		return(ToolTrap);
	else
		return(OSTrap);
}

Boolean	TrapAvailable(int theTrap)
{
	TrapType	tType;
	
	tType = GetTrapType(theTrap);
	if(tType == ToolTrap)	{
		theTrap &= 0x07ff;
		if(theTrap >= NumToolboxTraps())
			theTrap = _Unimplemented;
	}
	return(NGetTrapAddress(theTrap, tType) 
		!= NGetTrapAddress(_Unimplemented, ToolTrap));
}

Boolean	GestaltAvailable(void)
{
	return(TrapAvailable(_Gestalt));
}

#undef	_InitGraf
#undef	_Gestalt
#undef	TrapMask
#undef	_Unimplemented
