// datautils.h
#ifndef DATAUTILS_H_INCLUDED
#define DATAUTILS_H_INCLUDED

#ifdef DATAUTILS_SRC
#define SCOPE 
#else
#define SCOPE extern
#endif

#define PLOT_OBJECT_ID	'PLTO'

#define DATA_TOO_LARGE 	1.0e32
#define DATA_TOO_SMALL	-1.0e32
#define DATA_NEAR_ZERO  1.0e-32

#define TOPZONE		40	/* message region */
#define LEFTZONE	10  /* gauge region */

#define N_PLOTMARK	4	/* maximum number of marking position */

// Error code
#define NOERR 			0
#define ZERO_DATA		-1
#define OUT_OF_RANGE	-2

// track markee condition
#define MOVE_ONLY_HORIZ 0
#define MOVE_ONLY_VERT	1
#define MOVE_VH			2
#define CORNER_GROW 	3

// Resource ID
#define PLOT_WINDOW_ID	210
#define PLOT_VSCRL_ID	210
#define PLOT_HSCRL_ID	211

#define PLOT_RATE_ID	212		// for dialog and button
#define PLOT_MARK_ID	213		// for start marking 

#define PLOT_MARKCSR_ID		1200		// cursor for marking
#define PLOT_MARQUEECSR_ID	1201
#define PLOT_DEFAULTCSR_ID	1202		// cross hair black
#define PLOT_DRAGMARKCSR_ID	1203

#define PLOT_PPGREEN_ID		210			// you should prepare ppat resource of this ID
#define PLOT_PPYELLOW_ID	211
#define PLOT_PPRED_ID		212
#define PLOT_PPCYAN_ID		213
#define PLOT_PPRED2_ID		214


typedef struct{
	unsigned long  ObjectID;	// keep this structure is for plotting data. set to 'PLTO'
	Str255 ObjectName;			// name of this object.
	
	double *x;		// data area
	double *y;
	short n;		// data number
	
	double xorg;	// values at (0,0). 
	double yorg;
	
	double xpd;		// value difference per dot.
	double ypd;
	
	double xmin, xmax;	// minimum and maximum	
	double ymin, ymax;
	
	short hbarpos;		// keep horizontal bar position
	short hbarcurpos;	// keep currint position of horizontal bar
	double hbarval;
	Boolean isFirst;    // if FALSE, draw line with xor mode at current position  
	
	Point mpt;			// keep position of cursor in plotrect

	Boolean markflag;	// if it is true, you can use mark
	short markcount;	// counter of marker
	short marknum[N_PLOTMARK];		// data index(point) #
	double markxval[N_PLOTMARK];	// value at mark value
	short markxcrd[N_PLOTMARK];		// draw position of the marker
	
	RGBColor rgb;		// color of graph
	
	WindowPtr w;	// display window
	Rect plotrect;	// Rect for plotting region in w
	Rect currect;	// Rect for horizontal bar cursor w
	Rect valrect;   // Dislplay data(fixed mouse cursor)

	Rect pointvalrect;
	Rect barvalrect;
	Rect markvalrect;

	CCrsrHandle MarkCurHandle;
	CCrsrHandle MQCurHandle;
	CCrsrHandle DFCurHandle;
	CCrsrHandle DRCurHandle;
	
	ControlHandle vscrl;	// scroll bars
	ControlHandle hscrl;
	ControlHandle rateb;	// Graph zooming button
	ControlHandle markb;	// marking start button
	
} PlotFormat, *PlotFormatPtr, **PlotFormatHandle;


// easy color settings
#define PLOT_BLACK		0
#define PLOT_YELLOW		1
#define PLOT_MAGENTA	2
#define PLOT_RED		3
#define PLOT_CYAN		4
#define PLOT_GREEN		5
#define PLOT_BLUE		6
#define PLOT_WHITTE		7

#ifdef DATAUTILS_SRC
struct RGBColor PLOT_RGBs[8] = {{0x0000, 0x0000, 0x0000},
							 	{0xfc00, 0xf370, 0x052f},
							 	{0xf2d7, 0x0856, 0x84ec},
							 	{0xdd6b, 0x08c2, 0x06a2},
							 	{0x0241, 0xab54, 0xeaff},
							 	{0x0000, 0x8000, 0x11b0},
							 	{0x0000, 0x0000, 0xd400},
							 	{0xffff, 0xffff, 0xffff}};
#else
extern struct RGBColor PLOT_RGBs[];
#endif

// functions
SCOPE void  PLInit(PlotFormat *pl, short winID);
SCOPE WindowPtr  PLQuerywin(PlotFormat *pl);
SCOPE void   PLGoAway(PlotFormat *pl, EventRecord ev);
SCOPE void  PLScrlInit(PlotFormat *pl, short vscrID, short hscrID);
SCOPE void  PLSetScrlRange(PlotFormat *pl);
SCOPE void PLSetScrlVal(PlotFormat *pl);

SCOPE short  PLSetData(PlotFormat *pl, double datax[], double datay[], short num);
SCOPE void  PLSetDrawParms(PlotFormat *pl);
SCOPE void  PLFullDraw(PlotFormat *pl);
SCOPE void  PLDrawGraph(PlotFormat *pl);
SCOPE void PLSetInirialMarkPos(PlotFormat *pl, int pos[]);

SCOPE void  PLContentClick(PlotFormat *pl, EventRecord ev);
SCOPE void  PLDoMouseMove(PlotFormat *pl, EventRecord ev);
SCOPE void  PLDrawhbar(PlotFormat *pl);
SCOPE void PLHidehbar(PlotFormat *pl);
SCOPE void  PLDoMovehbar(PlotFormat *pl, EventRecord ev);
SCOPE short  PLDrawMark1Line(PlotFormat *pl, int i);
SCOPE void  PLDrawMarkLines(PlotFormat *pl);
SCOPE void PLHideMarkLines(PlotFormat *pl);
SCOPE short PLGetClickedMark(PlotFormat *pl, Point clickedpos);

SCOPE void  PLActionHscrl(PlotFormat *pl, EventRecord ev);
SCOPE void  PLActionVscrl(PlotFormat *pl, EventRecord ev);
SCOPE void  PLDoGrow(PlotFormat *pl, EventRecord ev);
SCOPE void  PLDoZoom(PlotFormat *pl, EventRecord ev);

SCOPE void  CalcHscrPos(WindowPtr win, Rect *r);
SCOPE void  CalcVscrPos(WindowPtr win, Rect *r);
SCOPE void PLTrackMarquee(PlotFormat *pl, Rect *r, Rect boundary, short condition);
SCOPE void PLMoveCursor(Point newpoint);
SCOPE void PLGetMarkBound(PlotFormat *pl, short mindex, Rect *boundRect);
SCOPE void PLResizeGraph(PlotFormat *pl, Rect *r);
SCOPE void PLAutoScaleGraph(PlotFormat *pl);


SCOPE void SortRect(Rect * dragRect);
SCOPE Boolean CompareRect(Rect *r1, Rect *r2);

#undef SCOPE

#endif /* DATAUTILS_H_INCLUDED */

