// debugs.cp
// G[bZ[W̕\s
#define DEBUGS_SRC
#include <Sound.h>
#include "debugs.h"

// debug routine for appleEvent

void AEError(OSErr aError)
{
	if(aError != noErr){
		SysBeep(1);
		switch(aError){
			/* Error messages in response to reading and writing event contents */
			case errAECoercionFail:
				ParamText("\perrAECoercionFail.", "\p","\p","\p");
				break;		
			case errAEDescNotFound:
				ParamText("\perrAEDescNotFound.", "\p","\p","\p");
				break;		
			case errAECorruptData:
				ParamText("\perrAECorruptData.", "\p","\p","\p");
				break;		
			case errAEWrongDataType:
				ParamText("\perrAEWrongDataType.", "\p","\p","\p");
				break;		
			case errAENotAEDesc:
				ParamText("\perrAENotAEDesc.", "\p","\p","\p");
				break;		
			case errAEBadListItem:
				ParamText("\pSpecified list item does not exist.", "\p","\p","\p");
				break;		
			case errAENewerVersion:
				ParamText("\pNeed newer version of AppleEvent Manager .", "\p","\p","\p");
				break;		
			case errAENotAppleEvent:
				ParamText("\phe event is not in AppleEvent format.", "\p","\p","\p");
				break;		

		/* Error messages in response to sending/receiving a message */		
			case errAEEventNotHandled:
				ParamText("\pThe AppleEvent was not handled by any handler.", "\p","\p","\p");
				break;		
			case errAEReplyNotValid:
				ParamText("\pAEResetTimer was passed an invalid reply parameter.", "\p","\p","\p");
				break;		
			case errAEUnknownSendMode:
				ParamText("\pMode wasn't NoReply, WaitReply, or QueueReply;  or Interaction level is unknown.", "\p","\p","\p");
				break;		
			case errAEWaitCanceled:
				ParamText("\pIn AESend, User cancelled out of wait loop for  reply or receipt.", "\p","\p","\p");
				break;		
			case errAETimeout:
				ParamText("\pAppleEvent timed out.", "\p","\p","\p");
				break;		
			case errAENoUserInteraction:
				ParamText("\pno user interaction allowed.", "\p","\p","\p");
				break;		
			case errAENotASpecialFunction:
				ParamText("\pthere is no special function with this keyword.", "\p","\p","\p");
				break;		
			case errAEParamMissed:
				ParamText("\pa required parameter was not accessed .", "\p","\p","\p");
				break;		
			case errAEUnknownAddressType:
				ParamText("\pThe target address type is not known.", "\p","\p","\p");
				break;		
			case errAEHandlerNotFound:
				ParamText("\pNo handler in the dispatch tables fits the parameters to AEGetEventHandler or AEGetCoercionHandler.", "\p","\p","\p");
				break;		
			case errAEReplyNotArrived:
				ParamText("\phe contents of the reply you are accessing have not arrived yet.", "\p","\p","\p");
				break;		
			case errAEIllegalIndex:
				ParamText("\pIndex is out of range in a put operation.", "\p","\p","\p");
				break;		
			/* from inside macnhintosh */
			case -50:
				ParamText("\pParameter Error(for example, value of handler pointer is NIL or odd.", "\p","\p","\p");
				break;
			case -92:
				ParamText("\pBuffer too bog to send.", "\p","\p","\p");
				break;
			case -108:
				ParamText("\pNot enough room for heap zone.", "\p","\p","\p");
				break;
			case -128:
				ParamText("\pUser canceled an operation", "\p","\p","\p");
				break;
			case -600:
				ParamText("\pNo eligible process with specified process serial number", "\p","\p","\p");
				break;
			case -607:
				ParamText("\pBuffer is too small", "\p","\p","\p");
				break;
			case -608:
				ParamText("\pNo outstanding high level event", "\p","\p","\p");
				break;
			case -609:
				ParamText("\pNonexistent signature or session ID", "\p","\p","\p");
				break;
			case -610:
				ParamText("\pBackground application sends event requiring authentication", "\p","\p","\p");
				break;
			case -903:
				ParamText("\pClient has't set 'SIZE' resource to indicate awareness of high level events", "\p","\p","\p");
				break;
			case -906:
				ParamText("\pServer hasn't set 'SIZE' resource to indicate awareness  of high-level events or else is not present.", "\p","\p","\p");
				break;
			case -917:
				ParamText("\pthe kAEDontReconnect flag in the sendMode parameter was set and the werver quit then restarted.", "\p","\p","\p");
				break;
			
			case -1720:
				ParamText("\pThe range is not valid because it is impossible for a range to include the first and last objects that  were specified.", "\p", "\p", "\p");
				break;
			case -1721:
				ParamText("\pThe number of operands provided for kAENot logical operator is not 1.", "\p", "\p", "\p");
				break;
			case -1723:
				ParamText("\pThere is no object accessor function for the specified object class and token descriptor type.", "\p", "\p", "\p");
				break;
			case -1725:
				ParamText("\pThe logical operator in a logical descriptor record is not kAEAnd, kAEOr, or kAENot.", "\p", "\p", "\p");
				break;
			case -1726:
				ParamText("\pThe descroptor record in a test key is neither a comparison descriptor record nor a logical descriptor record.", "\p", "\p", "\p");
				break;
			case -1727:
				ParamText("\pThe ObjectSpecifiler parameter of AEResolve is not an object specifier record.", "\p", "\p", "\p");
				break;
			case -1728:
				ParamText("\pA run time resolution error, for example:object specifier record asked for the third element, but there are only two.", "\p", "\p", "\p");
				break;
			case -1729:
				ParamText("\pObject-counting function returned negative value.", "\p", "\p", "\p");
				break;
			case -1730:
				ParamText("\pThe container for an Apple event object is specified by a empty list.", "\p", "\p", "\p");
				break;
			case -1731:
				ParamText("\pDescriptor type of token returned by AEResolve is not known to server application.", "\p", "\p", "\p");
				break;
			case -1732:
				ParamText("\pAttempt to turn recording on when it is already on.", "\p", "\p", "\p");
				break;
				
			default:
				ParamText("\pNot Apple event error!", "\p","\p","\p");
				break;
		}
		Alert(901, NULL);
	}
}


void  showcheck(void)
{
	Alert(900, NULL);
}


void  showmsgs(unsigned char *str0, unsigned char *str1, unsigned char *str2, unsigned char *str3)
{
	ParamText((unsigned char *)str0,
	          (unsigned char *)str1,
			  (unsigned char *)str2,
			  (unsigned char *)str3);
	Alert(902, NULL);
}

void  showstop(unsigned char *str0, unsigned char *str1, unsigned char *str2, unsigned char *str3)
{
	ParamText((unsigned char *)str0,
	          (unsigned char *)str1,
			  (unsigned char *)str2,
			  (unsigned char *)str3);
	StopAlert(905, NULL);
}

void  shownote(unsigned char *str0, unsigned char *str1, unsigned char *str2, unsigned char *str3)
{
	ParamText((unsigned char *)str0,
	          (unsigned char *)str1,
			  (unsigned char *)str2,
			  (unsigned char *)str3);
	NoteAlert(905, NULL);
}

void  showcaution(unsigned char *str0, unsigned char *str1, unsigned char *str2, unsigned char *str3)
{
	ParamText((unsigned char *)str0,
	          (unsigned char *)str1,
			  (unsigned char *)str2,
			  (unsigned char *)str3);
	CautionAlert(905, NULL);
}


// error trap for File Manager
void  FMError(OSErr aError)
{
	if(aError != noErr){
		SysBeep(1);
		switch(aError){
			case -28:
				ParamText("\pAppleTalk is not open.", "\p","\p","\p");
				break;
			case -33:
				ParamText("\pFile directory full.", "\p","\p","\p");
				break;
			case -34:
				ParamText("\pAll allocation blocks on the volume are full.", "\p","\p","\p");
				break;
			case -35:
				ParamText("\pVolume not found.", "\p","\p","\p");
				break;
			case -36:
				ParamText("\pI/O Error.", "\p","\p","\p");
				break;
			case -37:
				ParamText("\pBad filenameor volume name.", "\p","\p","\p");
				break;
			case -38:
				ParamText("\pFile not open.", "\p","\p","\p");
				break;
			case -39:
				ParamText("\pLogical end-of-file reached.", "\p","\p","\p");
				break;
			case -40:
				ParamText("\pAttempt to position mark before start of file.", "\p","\p","\p");
				break;
			case -42:
				ParamText("\pToo Many files open.", "\p","\p","\p");
				break;
			case -43:
				ParamText("\pFile not found.", "\p","\p","\p");
				break;
			case -44:
				ParamText("\pHardware volume lock.", "\p","\p","\p");
				break;
			case -45:
				ParamText("\pFile is locked.", "\p","\p","\p");
				break;
			case -46:
				ParamText("\pSoftware volume lock.", "\p","\p","\p");
				break;
			case -47:
				ParamText("\pFile is busy;one or more files are open;directory not empty or working directory control block is open.", "\p","\p","\p");
				break;
			case -48:
				ParamText("\pA file with the specific nonexistent access path.", "\p","\p","\p");
				break;
			case -49:
				ParamText("\pFile already open for writing", "\p","\p","\p");
				break;
			case -50:
				ParamText("\pParameter error.", "\p","\p","\p");
				break;
			case -51:
				ParamText("\pReference number specifies nonexistent access path;bad working directory reference number.", "\p","\p","\p");
				break;
			case -52:
				ParamText("\pError during GetFpos.", "\p","\p","\p");
				break;
			case -53:
				ParamText("\pVolume is offline.", "\p","\p","\p");
				break;
			case -54:
				ParamText("\pAttempt to open locked file for writing.", "\p","\p","\p");
				break;
			case -55:
				ParamText("\pSpecified volume is already mounted and online.", "\p","\p","\p");
				break;
			case -56:
				ParamText("\pSpecified drive number dosen't match any number in the drive queue.", "\p","\p","\p");
				break;
			case -57:
				ParamText("\pVolume lacks Macintosh-format directory.", "\p","\p","\p");
				break;
			case -58:
				ParamText("\pExternal file system.", "\p","\p","\p");
				break;
			case -59:
				ParamText("\pProblem during rename.", "\p","\p","\p");
				break;
			case -60:
				ParamText("\pBad master directory block.", "\p","\p","\p");
				break;
			case -61:
				ParamText("\pRead/write permission doesn't allow writing.", "\p","\p","\p");
				break;
			case -108:
				ParamText("\pInsufficient memory available.", "\p","\p","\p");
				break;
			case -120:
				ParamText("\pDirectory not found or incomplete pathname", "\p","\p","\p");
				break;
			case -121:
				ParamText("\pToo many working directories open.", "\p","\p","\p");
				break;
			case -122:
				ParamText("\pAttempted to move into offspring.", "\p","\p","\p");
				break;
			case -123:
				ParamText("\pNot an HFS volume.", "\p","\p","\p");
				break;
			case -124:
				ParamText("\pServer volume has been disconnected.", "\p","\p","\p");
				break;
			case -127:
				ParamText("\pInternal file system error.", "\p","\p","\p");
				break;
			case -1300:
				ParamText("\pFile ID not found.", "\p","\p","\p");
				break;
			case -1301:
				ParamText("\pFile ID already exists.", "\p","\p","\p");
				break;
			case -1302:
				ParamText("\pSpecified file is a direcory.", "\p","\p","\p");
				break;
			case -1303:
				ParamText("\pFile are on different volumes.", "\p","\p","\p");
				break;
			case -1304:
				ParamText("\pCatalog has changed and catalog position record may be invalid.", "\p","\p","\p");
				break;
			case -1306:
				ParamText("\pFiles are the same.", "\p","\p","\p");
				break;
			case -5000:
				ParamText("\pUser does not have the correct access to the file", "\p","\p","\p");
				break;
			case -5002:
				ParamText("\pUser authentication method is unknown.", "\p","\p","\p");
				break;
			case -5003:
				ParamText("\pWorkstation is using an AFP version that the server doesn't recognize.", "\p","\p","\p");
				break;
			case -5006:
				ParamText("\pThe operation has failed because the permission or deny mode conflicts with the mode in which the fork has already been opened.", "\p","\p","\p");
				break;
			case -5015:
				ParamText("\pByte range locking has failed because the server cannot lock any additional ranges.", "\p","\p","\p");
				break;
			case -5016:
				ParamText("\pServer is not responding.", "\p","\p","\p");
				break;
			case -5020:
				ParamText("\pUser has attempted to unlock a range that was not locked by that user.", "\p","\p","\p");
				break;
			case -5021:
				ParamText("\pUser attempted tp lock xome or all of a range that is alreaady locked.", "\p","\p","\p");
				break;
			case -5023:
				ParamText("\pUser authentication failed(usually, password is not correct).", "\p","\p","\p");
				break;
			case -5025:
				ParamText("\pObject was a file, not a directory;or,this directory is not a share point.", "\p","\p","\p");
				break;
			case -5033:
				ParamText("\pThe directory contains a share point.", "\p","\p","\p");
				break;
			case -5034:
				ParamText("\pFile ID  not found.", "\p","\p","\p");
				break;
			case -5035:
				ParamText("\pFild ID already exists.", "\p","\p","\p");
				break;
			case -5037:
				ParamText("\pCatalog has changed and search cannot be rexumed.", "\p","\p","\p");
				break;
			case -5038:
				ParamText("\pSource and destination are the same.", "\p","\p","\p");
				break;
			case -5039:
				ParamText("\pBad file ID", "\p","\p","\p");
				break;
			case -5042:
				ParamText("\pPassword  has expired on server.", "\p","\p","\p");
				break;
			case -5043:
				ParamText("\pThe directory is inside a shared directory.", "\p","\p","\p");
				break;
			case -5060:
				ParamText("\pNot a fixed directory ID volume.", "\p","\p","\p");
				break;
			case -5061:
				ParamText("\pMaximum number of volumes have been mounted.", "\p","\p","\p");
				break;
			case -5062:
				ParamText("\pVolume already mounted.", "\p","\p","\p");
				break;
			case -5063:
				ParamText("\pAttempt to log on to a server running on the same machine.", "\p","\p","\p");
				break;
		}
		Alert(903, NULL);
	}
}

void  RMError(short aError)
{
	if(aError != noErr){
		SysBeep(1);
		switch(aError){
			case -33:
				ParamText("\pDirectory Full", "\p","\p","\p");
				break;		
			case -34:
				ParamText("\pDisk Full", "\p","\p","\p");
				break;		
			case -35:
				ParamText("\pNo such volume", "\p","\p","\p");
				break;		
			case -36:
				ParamText("\pI/O error", "\p","\p","\p");
				break;		
			case -37:
				ParamText("\pBad Filename or volume name(perhaps zero length)", "\p","\p","\p");
				break;		
			case -39:
				ParamText("\pEnd of file", "\p","\p","\p");
				break;		
			case -42:
				ParamText("\pToo many files open", "\p","\p","\p");
				break;		
			case -43:
				ParamText("\pFile not found", "\p","\p","\p");
				break;		
			case -44:
				ParamText("\pDisk is write-protected", "\p","\p","\p");
				break;		
			case -45:
				ParamText("\pFile is locked", "\p","\p","\p");
				break;		
			case -46:
				ParamText("\pVolume is locked", "\p","\p","\p");
				break;		
			case -48:
				ParamText("\pDuplicate filename(rename)", "\p","\p","\p");
				break;		
			case -49:
				ParamText("\pFile already open with write permission", "\p","\p","\p");
				break;		
			case -54:
				ParamText("\pPermissons error(on file open)", "\p","\p","\p");
				break;		
			case -58:
				ParamText("\pVolume belongs to an external file system", "\p","\p","\p");
				break;		
			case -108:
				ParamText("\pNot enough room in heap zone", "\p","\p","\p");
				break;		
			case -120:
				ParamText("\pDirectory not found", "\p","\p","\p");
				break;		
			case -188:
				ParamText("\pResource already in memory", "\p","\p","\p");
				break;		
			case -189:
				ParamText("\pWriting past end of file", "\p","\p","\p");
				break;		
			case -190:
				ParamText("\pOffset or count out of bounds", "\p","\p","\p");
				break;		
			case -192:
				ParamText("\pResource not found", "\p","\p","\p");
				break;		
			case -193:
				ParamText("\pResource file not found", "\p","\p","\p");
				break;		
			case -194:
				ParamText("\pAddResource procedure failed", "\p","\p","\p");
				break;		
			case -196:
				ParamText("\pRemoveResource procedure failed", "\p","\p","\p");
				break;		
			case -198:
				ParamText("\pAttribute inconsistent with operation", "\p","\p","\p");
				break;		
			case -199:
				ParamText("\pMap inconsistent with operation", "\p","\p","\p");
				break;		
				
			default:
				ParamText("\pNot Resource Manager error!", "\p","\p","\p");
				break;
		}
		Alert(904, NULL);
	}
}

