/*****************************************************************************************/
/* File Name			: decl.h																																																																		*/
/* File Type			: C include (header) file												 																																				*/
/* Created 				: 1995																	 																																																		*/
/* Modified On	: 08/02/97																 																																															*/
/* Description	: Contains user variables (ibsta,iberr,ibcnt,ibcntl), 					 														*/
/*				  									function prototypes, and useful defined constants for calling NI-488				*/
/*				  									and NI-488.2 routines.												 																																					*/
/*																						 																																																																*/
/*  1997, National Instruments Corp.													 																																						*/
/*   All Rights Reserved																 																																																*/
/*****************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
		
extern unsigned short	ibsta;		/* status word 									*/
extern unsigned short	iberr;		/* GPIB error code 					*/
extern unsigned long		ibcnt;		/* number of bytes sent */
extern unsigned long 	ibcntl;


/* iblines bus lines */

#define BUS_EOI			0x8000
#define BUS_ATN			0x4000
#define BUS_SRQ			0x2000
#define BUS_REN			0x1000
#define BUS_IFC			0x0800
#define BUS_NRFD		0x0400
#define BUS_NDAC		0x0200
#define BUS_DAV			0x0100


/* iblines valid bus lines */

#define VALID_EOI			0x0080
#define VALID_ATN			0x0040
#define VALID_SRQ			0x0020
#define VALID_REN			0x0010
#define VALID_IFC			0x0008
#define VALID_NRFD		0x0004
#define VALID_NDAC		0x0002
#define VALID_DAV			0x0001

/* The user status flags */
#define ERR					0x8000	/* error occurred (must be Int16 for sign extension) */
#define TIMO				0x4000	/* timeout 																																										*/
#define END					0x2000	/* END detected 																																					*/
#define SRQI				0x1000	/* SRQ interrupt 																																				*/
#define RQS					0x0800	/* device is requesting service 																					*/
#define ADSC				0x0400	/* address status change 																												*/
#define BADBIT  0x0200 /* this bit is not used 																													*/
#define CMPL				0x0100	/* dma completed 																																				*/
#define LOK					0x0080	/* local lockout state 																														*/
#define REM					0x0040	/* remote state 																																					*/
#define CIC					0x0020	/* controller in charge 																													*/
#define ATN					0x0010	/* ATN line 																																									*/
#define TACS				0x0008	/* talker active 																																				*/
#define LACS				0x0004	/* listener active 																																		*/
#define DTAS				0x0002	/* device trigger state 																													*/
#define DCAS				0x0001	/* device clear state 																															*/

/* Error Codes	*/
#define	EDVR			0		/* driver or operating system error 															*/
#define ECIC			1		/* not controller in charge 																							*/
#define ENOL			2		/* no listeners, ibwrt 																												*/
#define EADR			3		/* CIC and not addressed before I/O 															*/
#define EARG			4		/* bad argument to function call 																		*/
#define ESAC			5		/* not system controller, ibsre and ibsic 									*/
#define EABO			6		/* operation aborted (timeout) 																				*/
#define ENEB			7		/* Non existant board 																													*/
#define	EDMA			8		/* DMA hardware error detected 																				*/
#define EOIP			10	/* I/O started before previous operation completed */
#define ECAP			11	/* no capability for intended operation 											*/
#define EFSO			12	/* file system error 																														*/
#define EBUS			14	/* GPIB bus error 																																	*/
#define ESTB			15	/* serial poll bytes queue overflow 															*/
#define ESRQ			16	/* SRQ stuck on 																																			*/
#define EASC			17	/* address status change during I/O command 							*/
#define EDC				18	/* DCAS occurred during I/O command															 */
#define ETAB   20 /* The return buffer is full.      															 */
#define ELCK 		21 /* Board or Device is locked 																						*/


/***********************************************************************************/
/*  The following constants are used for the second parameter of the ibconfig      */
/*  function.  They are the "option" selection codes.																														*/
/***********************************************************************************/

#define  IbcPAD        				0x0001      		/* Primary Address                        */
#define  IbcSAD        				0x0002      		/* Secondary Address                      */
#define  IbcTMO        				0x0003      		/* Timeout Value                          */
#define  IbcEOT        				0x0004      		/* Send EOI with last data byte?          */
#define  IbcPPC        				0x0005      		/* Parallel Poll Configure                */
#define  IbcREADDR     				0x0006      		/* Repeat Addressing                      */
#define  IbcAUTOPOLL   				0x0007      		/* Disable Auto Serial Polling            */
#define  IbcCICPROT   			 	0x0008      		/* Use the CIC Protocol?                  */
#define  IbcIRQ        				0x0009      		/* Use PIO for I/O                        */
#define  IbcSC         				0x000A      		/* Board is System Controller?            */
#define  IbcSRE        				0x000B      		/* Assert SRE on device calls?            */
#define  IbcEOSrd      				0x000C      		/* Terminate reads on EOS                 */
#define  IbcEOSwrt     			 0x000D      		/* Send EOI with EOS character            */
#define  IbcEOScmp     				0x000E      		/* Use 7 or 8-bit EOS compare             */
#define  IbcEOSchar    				0x000F      		/* The EOS character.                     */
#define  IbcPP2        				0x0010      		/* Use Parallel Poll Mode 2.              */
#define  IbcTIMING     				0x0011      		/* NORMAL, HIGH, or VERY_HIGH timming.    */
#define  IbcDMA        				0x0012      		/* Use DMA for I/O                        */
#define  IbcReadAdjust  			0x0013  						/* Byte Swapping on Reads  															*/
#define  IbcWriteAdjust 			0x0014  						/* Byte Swapping on Writes 															*/
#define 	IbcSendLLO								0x0017								/* Enable/Disable sending of LLO										*/
#define  IbcSPollTime   			0x0018  						/* Serial Poll Timeout 																			*/
#define  IbcPPollTime						0x0019								/* Set Parallel Poll length period								*/
#define 	IbcEndBitIsNormal 0x001A								/* Remove EOS from End bit of IBSTA							*/
#define  IbcUnAddr									0x001B  						/* Unaddressing of devices																*/
#define  IbcHSCableLength		0x001F  						/* TNT cable length 																						*/
#define 	IbcIst												0x0020							 /* Set the IST bit																							 */
#define  IbcRsv										  0x0021							 /* Set the RSV bit																								*/
#define  IbcLON         			0x0022  						/* listen only 																											*/


/***********************************************************************************/
/*  The following constants are used for the second parameter of the ibask function*/
/*  They are the "option" selection codes. Not all apply to Macintosh.													*/
/***********************************************************************************/

#define  IbaPAD        			 0x0001      	/* Primary Address                          */
#define  IbaSAD        			 0x0002      	/* Secondary Address                        */
#define  IbaTMO        			 0x0003      	/* Timeout Value                            */
#define  IbaEOT        			 0x0004      	/* Send EOI with last data byte?            */
#define  IbaPPC        			 0x0005      	/* Parallel Poll Configure                  */
#define  IbaREADDR     			 0x0006      	/* Repeat Addressing                        */
#define  IbaAUTOPOLL   			 0x0007      	/* Disable Auto Serial Polling              */
#define  IbaCICPROT   			  0x0008      	/* Use the CIC Protocol?                    */
#define  IbaIRQ        			 0x0009      	/* Use PIO for I/O                          */
#define  IbaSC         			 0x000A      	/* Board is System Controller?              */
#define  IbaSRE        			 0x000B      	/* Assert SRE on device calls?              */
#define  IbaEOSrd      			 0x000C      	/* Terminate reads on EOS                   */
#define  IbaEOSwrt     			 0x000D      	/* Send EOI with EOS character              */
#define  IbaEOScmp     			 0x000E      	/* Use 7 or 8-bit EOS compare               */
#define  IbaEOSchar    			 0x000F      	/* The EOS character.                       */
#define  IbaPP2        			 0x0010      	/* Use Parallel Poll Mode 2.                */
#define  IbaTIMING     			 0x0011      	/* NORMAL, HIGH, or VERY_HIGH timming.      */
#define  IbaDMA        			 0x0012      	/* Use DMA for I/O                          */
#define  IbaReadAdjust  		 0x0013  					/* Byte Swapping on Reads  																	*/
#define  IbaWriteAdjust 		 0x0014  					/* Byte Swapping on Writes 																	*/
#define  IbaSPollTime   		 0x0018  					/* serial poll timeout 																					*/
#define 	IbaEndBitIsNormal	0x001A							/* Remove EOS from End bit of IBSTA									*/
#define  IbaUnAddr								 0x001B  					/* Unaddressing of devices																		*/
#define  IbaHSCableLength	 0x001F  					/* TNT cable length 																								*/
#define 	IbaIst												0x0020							/* Set the IST bit								  															 */
#define  IbaRsv										  0x0021							/* Set the RSV bit												  												*/
#define  IbaLON         		 0x0022  					/* listen only 																													*/
#define  IbaBNA											 0x0200
#define	 IbaBaseAddr						 0x0201
#define  IbaDmaChannel				 0x0202
#define  IbaIrqLevel						 0x0203
#define  IbaBaud											0x0204
#define  IbaParity									0x0205
#define  IbaStopBits							0x0206
#define  IbaDataBits							0x0207
#define  IbaComPort								0x0208
#define  IbaComIrqLevel				0x0209
#define  IbaComPortBase				0x020A
#define  IbaSingleCycleDma	0x020B
#define  IbaSocketNumber			0x020C
#define  IbaLPTNNumber					0x020D
#define	 IbaLPTType								0x020E

#define  ibaPAD        			 IbaPAD      						/* Primary Address                          */
#define  ibaSAD        			 IbaSAD      						/* Secondary Address                        */
#define  ibaTMO        			 IbaTMO      						/* Timeout Value                            */
#define  ibaEOT        			 IbaEOT      						/* Send EOI with last data byte?            */
#define  ibaPPC        			 IbaPPC      						/* Parallel Poll Configure                  */
#define  ibaREADDR     			 IbaREADDR   						/* Repeat Addressing                        */
#define  ibaAUTOPOLL   			 IbaAUTOPOLL 						/* Disable Auto Serial Polling              */
#define  ibaCICPROT   			  IbaCICPROT  						/* Use the CIC Protocol?                    */
#define  ibaIRQ        			 IbaIRQ      						/* Use PIO for I/O                          */
#define  ibaSC         			 IbaSC       						/* Board is System Controller?              */
#define  ibaSRE        			 IbaSRE      						/* Assert SRE on device calls?              */
#define  ibaEOSrd      			 IbaEOSrd    						/* Terminate reads on EOS                   */
#define  ibaEOSwrt     			 IbaEOSwrt   						/* Send EOI with EOS character              */
#define  ibaEOScmp     			 IbaEOScmp   						/* Use 7 or 8-bit EOS compare               */
#define  ibaEOSchar    			 IbaEOSchar  						/* The EOS character.                       */
#define  ibaPP2        			 IbaPP2      						/* Use Parallel Poll Mode 2.                */
#define  ibaTIMING     			 IbaTIMING   						/* NORMAL, HIGH, or VERY_HIGH timming.      */
#define  ibaDMA        			 IbaDMA      						/* Use DMA for I/O                          */
#define  ibaReadAdjust  		 IbaReadAdjust  			/* Byte Swapping on Reads  																	*/
#define  ibaWriteAdjust 		 IbaWriteAdjust				/* Byte Swapping on Writes 																	*/
#define  ibaSPollTime   		 IbaSPollTime 					/* serial poll timeout 																					*/
#define	 ibaEndBitIsNormal	IbaEndBitIsNormal	/* Remove EOS from End bit of IBSTA									*/
#define  ibaUnAddr								 IbaUnAddr									/* Unaddressing of devices																		*/
#define  ibaHSCableLength	 IbaHSCableLength		/* TNT cable length 																								*/
#define 	ibaIst												IbaIst												/* Set the IST bit								  															 */
#define  ibaRsv												IbaRsv			  							/* Set the RSV bit												  												*/
#define  ibaLON         		 IbaLON					  					/* listen only 																													*/
#define  ibaBNA											 IbaBNA
#define	 ibaBaseAddr						 IbaBaseAddr
#define  ibaDmaChannel				 IbaDmaChannel
#define  ibaIrqLevel						 IbaIrqLevel
#define  ibaBaud										 IbaBaud
#define  ibaParity								 IbaParity
#define  ibaStopBits						 IbaStopBits
#define  ibaDataBits						 IbaDataBits
#define  ibaComPort						  IbaComPort
#define  ibaComIrqLevel			 IbaComIrqLevel
#define  ibaComPortBase			 IbaComPortBase
#define  ibaSingleCycleDma	IbaSingleCycleDma
#define  ibaSocketNumber			IbaSocketNumber
#define  ibaLPTNNumber					IbaLPTNNumber
#define	 ibaLPTType								IbaLPTType



/* NI-488.2 Declared Constants */

#define NULLend  			0x00         /* Do nothing at the end of a transfer.   	*/
#define NLend    			0x01         /* Send NL with EOI after a transfer.     	*/
#define DABend   			0x02         /* Send EOI with the last DAB.            	*/

#define STOPend   		0x0100       /* terminate reads on EOI bit asserted 				*/

#define NULL_END 		NULLend
#define NL_END 				NLend
#define DAB_END 			DABend
#define STOP_END			STOPend			


/***********************************************************************************/
/* Address type (for 488.2 calls) 																																																	*/
/***********************************************************************************/

typedef short Addr4882_t ;

/***********************************************************************************/
/* This value is used to terminate an address list.  It should be assigned to the 	*/
/*  last entry																																																																					*/
/***********************************************************************************/

#define  NOADDR    			(Addr4882_t)0xFFFF  
          

/***********************************************************************************/
/* NI-488.2 Special Purpose Address Manipulation Macros 																											*/
/***********************************************************************************/

#define  GetSAD(address)     (((address) >> 8) & 0xFF)
#define  GetPAD(address)     (((address) & 0xFF))
#define  MakeAddr(pad,sad)   (Addr4882_t)(((pad) &0xFF) | ((sad) << 8))

/***********************************************************************************/
/*   This macro is used to clear out the talk address and listen 																		*/
/*   address bits from the given PAD.  It then ORs in the given bit. 														*/
/***********************************************************************************/
 
#define FixPAD(pad, bit)     ((uchar)(((pad) & ~(LAD | TAD)) | (bit))


#define  ALL_SAD  			-1
#define  NO_SAD   			 0
#define  SAD_MASK 			 0x60


/***********************************************************************************/
/*  The following values are used by the iblines function.  The unsigned											*/
/*  integer returned by iblines contains:																																										*/
/*       The lower byte will contain a "monitor" bit mask.  If a bit is												*/
/*          set (1) in this mask, then the corresponding line can be															*/
/*          monitiored by the driver.  If the bit is clear (0),																				*/
/*          then the line cannot be monitored.																																					*/
/*       The upper byte will contain the status of the bus lines.																		*/
/*          Each bit corresponds to a certain bus line, and has																				*/
/*          a correcponding "monitor" bit in the lower byte.																							*/
/*																																																																																	*/
/***********************************************************************************/

#define  BusEOI     		(unsigned short)0x8000
#define  BusATN     		(unsigned short)0x4000
#define  BusSRQ     		(unsigned short)0x2000
#define  BusREN     		(unsigned short)0x1000
#define  BusIFC     		(unsigned short)0x0800
#define  BusNRFD    		(unsigned short)0x0400
#define  BusNDAC    		(unsigned short)0x0200
#define  BusDAV     		(unsigned short)0x0100

#define ValidEOI				0x0080
#define ValidATN				0x0040
#define ValidSRQ				0x0020
#define ValidREN				0x0010
#define ValidIFC				0x0008
#define ValidNRFD			0x0004
#define ValidNDAC			0x0002
#define ValidDAV				0x0001



#define badSerialResponse	-10000			/* bad response from serial-GPIB converter 		*/
#define badSerialState				-10100			/* bad state in serial-GPIB converter driver */


/***********************************************************************************/
/* EOS Modes																																																																	      */
/***********************************************************************************/


#define BIN  				(1<<12)		/* Eight bit compare 					*/
#define XEOS 				(1<<11)		/* Send EOI with EOS byte */
#define REOS 				(1<<10)		/* Terminate read on EOS 	*/

/***********************************************************************************/
/* Timeout Values																																																												      */
/***********************************************************************************/

#define TNONE	 					0		/* timeout disabled 			*/
#define T10us	 					1		/* timeout of 10 us 			*/
#define T30us	 					2		/* timeout of 30 us 			*/
#define T100us	 				3		/* timeout of 100 us 		*/
#define T300us	 				4		/* timeout of 300 us 		*/
#define T1ms	 						5		/* timeout of 1 ms 				*/
#define T3ms	 						6		/* timeout of 3 ms 				*/
#define T10ms	 					7		/* timeout of 10 ms 			*/
#define T30ms	 					8		/* timeout of 30 ms 			*/
#define T100ms	 				9		/* timeout of 100 ms 		*/
#define T300ms					10		/* timeout of 300 ms 		*/
#define T1s								11		/* timeout of 1 s 					*/
#define T3s								12		/* timeout of 3 s 					*/
#define T10s							13		/* timeout of 10 s 				*/
#define T30s							14		/* timeout of 30 s 				*/
#define T100s						15		/* timeout of 100 s 			*/
#define T300s						16		/* timeout of 300 s 			*/
#define T1000s					17		/* timeout of 1000 s 		*/

/***********************************************************************************/
/* GPIB Commands																																																													      */
/***********************************************************************************/

#define GTL	(unsigned char)0x1		 /* go to local														*/
#define SDC	(unsigned char)0x4		 /* selected device clear 			*/
#define PPC	(unsigned char)0x5		 /* parallel poll configure 	*/
#define GET	(unsigned char)0x8		 /* group execute trigger 			*/
#define TCT	(unsigned char)0x9		 /* take control 												*/
#define LLO	(unsigned char)0x11		/* local lockout												*/
#define DCL	(unsigned char)0x14		/* device clear 												*/
#define PPU	(unsigned char)0x15		/* parallel poll unconfigure*/
#define SPE	(unsigned char)0x18		/* serial poll enable 						*/
#define SPD	(unsigned char)0x19		/* serial poll disable 					*/
#define UNL	(unsigned char)0x3F		/* unlisten 																*/
#define UNT	(unsigned char)0x5F		/* untalk 																		*/
#define PPE	(unsigned char)0x60		/* parallel poll enable					*/
#define PPD	(unsigned char)0x70		/* parallel poll disable				*/
#define S	  (unsigned char)0x08		/* parallel poll Sense Bit		*/


/***********************************************************************************/
/*  Function Prototypes NI-488.1																																													      */
/***********************************************************************************/

short 	ibask			(short,short,short*);				
short 	ibcac			(short,short);				
short 	ibclr			(short);					
short 	ibcmd			(short,void*,long); 		
short 	ibcmda		(short,void*,long); 	
short 	ibdev			(short,short,short,short,short,short);
short 	ibdma			(short,short);				
short 	ibeos			(short,short);				
short 	ibeot			(short,short);						
short 	ibfind		(char*);				
short 	ibgts			(short,short);				
short 	ibist			(short,short);				
short 	ibln			 (short,short,short,short*);	
short 	ibllo			(short);				
short 	ibloc			(short);					
short 	iblines	(short,unsigned short*);
short 	ibonl			(short,short);				
short 	ibpad			(short,short);				
short 	ibpct			(short); 				
short 	ibppc			(short,short);			
short 	ibrd			 (short,void*,long); 		
short 	ibrda			(short,void*,long); 		
short 	ibrdf			(short,char*);			
short 	ibrpp			(short,char*);			
short 	ibrsc			(short,short);				
short 	ibrsp			(short,char*); 			
short 	ibrsv			(short,short);				
short		ibsad			(short,short);				
short 	ibsic			(short);					
short 	ibsre			(short,short);				
short 	ibstop		(short);				
short 	ibtmo			(short,short);				
short 	ibtrg			(short); 				
short 	ibwait		(short,short);			
short 	ibwrt			(short,void*,long); 		
short 	ibwrta		(short,void*,long); 	
short 	ibwrtf		(short,char*);			
short 	iblock		(short);					
short 	ibunlock	(short);					

/***********************************************************************************/
/*  Function Prototypes NI-488.2																																													      */
/***********************************************************************************/

void 		SendCmds							(short,char*,unsigned long); 	
void 		SendSetup						(short,Addr4882_t*);      
void 		SendIFC								(short);               
void 		SendDataBytes		(short,char*,long,short); 
void 		Send											(short,Addr4882_t,char*,long,short);  
void 		ReceiveSetup			(short,Addr4882_t);             
void 		RcvRespMsg					(short,char*,unsigned long,short);    
void 		Receive								(short,Addr4882_t,void*,long,short);  
void 		DevClear							(short,Addr4882_t);             
void 		SendList							(short,Addr4882_t*,char*,long,short);
void 		DevClearList			(short,Addr4882_t *);
void 		EnableLocal				(short,Addr4882_t *);
void 		EnableRemote			(short,Addr4882_t*);
void 		SetRWLS								(short,Addr4882_t*);
void 		SendLLO								(short);
void 		Trigger								(short,Addr4882_t);
void 		PassControl				(short,Addr4882_t);
void 		ReadStatusByte	(short,Addr4882_t,short*);
void 		TriggerList				(short,Addr4882_t *);
void 		PPollConfig				(short,Addr4882_t,short,short);
void 		PPollUnconfig		(short,Addr4882_t*);
void 		PPoll										(short,short*);
void 		TestSRQ								(short,short*);
void 		WaitSRQ								(short,short*);
void 		ResetSys							(short,Addr4882_t *);
void 		FindRQS								(short,Addr4882_t*,short*);
void 		AllSpoll							(short,Addr4882_t*,short*);
void			FindLstn							(short,Addr4882_t*,Addr4882_t*,short);
void 		TestSys								(short,Addr4882_t*,short*);
short 	ibconfig							(short,unsigned short,unsigned short);
short 	ibpoke									(short,short,void*);
short 	ibsrq										(void(*func)(void));
short 	ibbna										(short,char*);
short 	ibdiag									(short,void*,long);
short 	ibrdkey								(short,void*,long);
short 	ibwrtkey							(short,void*,long);



#ifdef __cplusplus
}
#endif