// inputdialog.h
// by apj
#ifndef INPUTDIALOG_H_INCLUDED
#define INPUTDIALOG_H_INCLUDED

#ifdef INPUTDIALOG_SRC
#define SCOPE
#else
#define SCOPE extern
#endif

#define EDIT_OBJECT_ID 'EDTO'

#define L_LABEL 40
#define L_FORMAT 10
#define N_ITEMS 50     /* maximum number of editable items */

#define kMaxTELength 256

// for key handling
#define kTab 0x09
#define kDel 0x08
#define kRightArrow 0x1d
#define kLeftArrow 0x1c
#define kDownArrow 0x1F
#define kUpArrow 0x1e
#define kCR 0x0d


#define EDTI_RESTYPE	'EdtI'

#if PRAGMA_ALIGN_SUPPORTED
#pragma options align=mac68k
#endif

// for 'EdtI' resource
typedef struct {
	short lx, ly;				/* location of title */
	Str255 label;    			/* for title */
	short ex, ey;				/* location of TextEdit box(f_rect) */
	Rect f_rect;				/* outer frame of TextEdit. top+1, both sides +5, bottom+0 */
	Rect t_rect;            	/* for TextEdit. Height must be more than 17 to use 12pt font */
	Str255 format;				/* %s,%d, etc. */
} EdtIRecord, *EdtIPtr, **EdtIHandle;

#if PRAGMA_ALIGN_SUPPORTED
#pragma options align=reset
#endif

typedef struct {
	short lx, ly;			/* location of title */
	char label[L_LABEL];    /* for title */
	short ex, ey;			/* location of TextEdit box(f_rect) */
	Rect f_rect;			/* outer frame of TextEdit. top+1, both sides +5, bottom+0 */
	Rect t_rect;            /* for TextEdit. Height must be more than 17 to use 12pt font */
	char format[L_FORMAT];	/* %s,%d, etc. */
	TEHandle te;
} EditItem;


typedef struct {
	unsigned long  ObjectID;	// keep this structure is for plotting data. set to 'PLTO'
	Str255 ObjectName;			// name of this object.

	EditItem item[N_ITEMS];
	WindowPtr w;			/* display window */
	short inum;				/* number of items */
	TEHandle curte;         /* current text handle */
} EditPanel;


// functions
SCOPE void  EIinit(EditItem *ei);
SCOPE void  EIDraw(EditItem ei);
SCOPE void  EPGoAway(EditPanel *ep, EventRecord ev);
SCOPE void  EPInit(EditPanel *ep, short winID, short (*SetItems)(EditItem ei[]) );
SCOPE void  EPDraw(EditPanel *ep);
SCOPE WindowPtr  EPQuerywin(EditPanel *ep);
SCOPE void  EPDoMouseMove(EditPanel *ep, EventRecord ev);
SCOPE short  EPChekInEditable(EditPanel *ep);
SCOPE void  EPIdle(EditPanel *ep);
SCOPE void  EPDeactivate(EditPanel *ep);
SCOPE void  EPClicked(EditPanel *ep, EventRecord ev);
SCOPE void  EPHandleKeyDown(EditPanel *ep, EventRecord ev);
SCOPE short  getTESelLength(TERec te);
SCOPE void  EPGetContent(EditPanel *ep, short n, char *str);
SCOPE void  EPSetContent(EditPanel *ep, short n, char *str);
SCOPE void  TERectToStr(TEHandle te, Str255 str);
SCOPE void  StrToTERec(Str255 str, TEHandle te);


#undef SCOPE

#endif  /* INPUTDIALOG_H_INCLUDED */