// showlist.cp
// f[^̈ꕔ邽߂̃Xg{bNX
#define SHOWLIST_SRC
#include <complex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Strings.h>

#include <Sound.h>
#include "debugs.h"
#include "showlist.h"
#include "fileio.h"


void  SLInit(ShowList *sl, short winID)
{
	GrafPtr cptr;
	
	GetPort(&cptr);
	
	sl->w = GetNewCWindow(winID, nil, (WindowPtr)-1);
	SetPort(sl->w);
	SetWRefCon(sl->w, (long)sl);
	sl->ObjectID = LIST_OBJECT_ID;
	
	SetRect(&(sl->dbounds), 0, 0, 1, 0);
	SetPt(&(sl->csize), 0, 0);
	SetRect(&(sl->lrect), 0, 0, (*(sl->w)).portRect.right-16 , (*(sl->w)).portRect.bottom -16);
	sl->listh = LNew(&(sl->lrect), &(sl->dbounds), sl->csize, 0, (WindowPtr)sl->w, TRUE,TRUE,TRUE,TRUE);
	HLock((Handle)sl->listh);
	sl->csize = (*(sl->listh))->cellSize;
	
	sl->n_row = 0;
	
	SetPort(cptr);
}


WindowPtr  SLQuerywin(ShowList *sl)
{
	return sl->w;
}

void  SLSet1Data(ShowList *sl, char *str)
{
	short dummy;
	
	dummy = LAddRow(1, sl->n_row, sl->listh);
	SetPt(&(sl->csize), 0, sl->n_row);
	LAddToCell(str, strlen(str), sl->csize, sl->listh);
	LDraw(sl->csize, sl->listh);
	sl->n_row = sl->n_row + 1;
}

void  SLDoUpdate(ShowList *sl)
{
	LUpdate(sl->w->visRgn, sl->listh);
	DrawGrowIcon(sl->w);
}


void  SLContentClick(ShowList *sl, EventRecord ev)
{
	Boolean beep;

	GlobalToLocal(&(ev.where));
	beep = LClick(ev.where, ev.modifiers,sl->listh);
	if(beep)
		SysBeep(10);
}

void  SLDoGrow(ShowList *sl, EventRecord ev)
{
	GrafPtr cptr;
	long windsize;
	Rect sizerect;
	
	windsize = GrowWindow(sl->w, ev.where, &sizerect);
	if(windsize){
		GetPort(&cptr);
		SetPort(sl->w);
		EraseRect(&(sl->w)->portRect);
		SizeWindow(sl->w, LoWord(windsize), HiWord(windsize), TRUE);
		LSize(LoWord(windsize) - 15, HiWord(windsize)-15, sl->listh);
		sl->csize.h = LoWord(windsize) - 15;
		LCellSize(sl->csize, sl->listh);
		DrawGrowIcon(sl->w);
		InvalRect(&(sl->w)->portRect);
		SetPort(cptr);
	}
}

	

void  SLGoAway(ShowList *sl, EventRecord ev)
{
	if(sl->w == FrontWindow()){
		if(TrackGoAway(sl->w, ev.where)){
			HUnlock((Handle)sl->listh);
			LDispose(sl->listh);
			DisposeWindow(sl->w);
		}
	}
}

void  SLClearCell(ShowList *sl, short num)
{

	LDelRow(0, 0, sl->listh);

	sl->n_row = 0;
	
}

void  SLHideList(ShowList *sl, EventRecord ev)
{
	if(sl->w == FrontWindow()){
		if(TrackGoAway(sl->w, ev.where)){
			HideWindow(sl->w);
		}
	}
}

short SLQueryNumRow(ShowList *sl)
{
	return sl->n_row;
}

short SLGet1Data(ShowList *sl, short rownum, char *str, short *len)
{
	Cell theCell;
	
	if(rownum < 0 || rownum >= sl->n_row){
		strcpy(str, "");
		return -1;
	}
	
	theCell.h = 0;
	theCell.v = rownum;
	LGetCell(str, len, theCell, sl->listh);
	return 0;
} 
	 

short SLDoSave(ShowList *sl, FileIO *fio)
{
	char buf[256];
	short pathRefNum;
	short i, len;
	Cell theCell;
	OSErr err;
	
	StandardPutFile("\pOutput file name", "\pUntitled", &(fio->sfr));
	if(!fio->sfr.sfGood) return 0;	// canceled.

	fio->fss =  fio->sfr.sfFile;

	err = FSpCreate(&(fio->fss),'TDRS','TEXT', smSystemScript);
	if(err != noErr && err != dupFNErr){ 
		FMError(err);
	}
	err = FSpOpenDF(&(fio->fss), fsWrPerm, &pathRefNum);
	if(err != noErr){
		FMError(err);
	}
	if(SetUpFileIO(pathRefNum, fsWrPerm, fio) != 0){
		showmsgs("\pCan't alloc memory for buffer of output file", NULL,NULL,NULL);
		ExitToShell();
	}

	theCell.h = 0; theCell.v = 0;
	for(i = 0 ; i < sl->n_row ; i++){
		theCell.v = i;
		len = 254;
		LGetCell(buf, &len, theCell, sl->listh);
		buf[len] = '\n'; buf[len+1] = '\0';
		if(Write1Line(fio, buf, 256) != noErr){
			CloseFileIO(fio);
			return -1;
		}
	}
	CloseFileIO(fio);
	return 0;
}
