// showlist.h
#ifndef SHOWLIST_H_INCLUDED
#define SHOWLIST_H_INCLUDED

#include <Lists.h>
#include "fileio.h"

#ifdef SHOWLIST_SRC
#define SCOPE 
#else
#define SCOPE extern
#endif

#define LIST_OBJECT_ID	'LSTO'

#define LIST_WINDOW_ID	211		// causion! Don't forget make WIND resource No. 211



typedef struct{
	unsigned long ObjectID;
	Str255 ObjectName;

	WindowPtr	w;
	Rect 		lrect, dbounds;
	ListHandle	listh;
	Point		csize;
	short 		n_row;
} ShowList;


SCOPE void  SLInit(ShowList *sl, short winID);
SCOPE WindowPtr  SLQuerywin(ShowList *sl);
SCOPE void  SLSet1Data(ShowList *sl, char *str);
SCOPE void  SLDoUpdate(ShowList *sl);
SCOPE void  SLContentClick(ShowList *sl, EventRecord ev);
SCOPE void  SLGoAway(ShowList *sl, EventRecord ev);
SCOPE void  SLClearCell(ShowList *sl, short num);
SCOPE void  SLHideList(ShowList *sl, EventRecord ev);
SCOPE void  SLDoGrow(ShowList *sl, EventRecord ev);
SCOPE short SLQueryNumRow(ShowList *sl);
SCOPE short SLGet1Data(ShowList *sl, short rownum, char *str, short *len);
SCOPE short SLDoSave(ShowList *sl, FileIO *fio);

#undef SCOPE

#endif /* SHOWLIST_H_INCLUDED */
