// stde.h
// header file of stde.cp
// Parameters are from TOKAI UNIV.

#ifndef STDE_H_INCLUDED
#define STDE_H_INCLUDED

#ifdef STDE_SRC
#define SCOPE
#else
#define SCOPE extern
#endif

#define STD_READBUF 200   // read buffer


#define NUM_STD 11       // W9ށBǉ̍ۂ͂̐𑝂₷
#define STD_PARMS 6
#define STD_NAMELEN 50  

typedef struct{
        char name[STD_NAMELEN]; 	// sample name
        int flag;               	// method of calculation
        double p[STD_PARMS];
}StandardParam;


// Index of standard sample
//  : Macintosh̃v_Ej[͍ŏ̗vfI΂ƂPԂ
//        ł͍ŏ̗vf̔ԍ͂Oł
#define STD_AIR			0
#define STD_WATER		1
#define STD_ACETONE		2
#define STD_CHLORO		3
#define STD_BENZENE		4
#define STD_TOLUENE		5
#define STD_ETHANOL		6
#define STD_METHANOL	7
#define STD_WATER_KAATZE	8	// 1996.11.27
#define STD_ETHANOL2	9		// 1997.07.07
#define STD_PROPANOL	10		// 1997.07.07

// WvZp̃p[^
// ^̕Wł́AL@n}ׂē`ŌvZł̂Ńp[^\ɂ
// ̕WvZ@ǉ邱ƂlƁA͂܂ǂł͂Ȃ
// ȂB
#ifdef STDE_SRC
StandardParam StdP[NUM_STD] = {
 			{"Air",   0, { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0} },
 			{"Water", 0, { 0.40008, 87.74, 0.0167857, 4.88214, -0.0108, -10.790} },
 			{"Acetone", 2, { -0.1025, 23.3440, -0.001538, 1.93128, -3.1268e-14, 3.996e-12} },
 			{"Chroloform", 2, { -0.02197, 5.26725, -0.001994, 2.12985, -0.19649e-12, 12.33925e-12} },
 			{"Benzene", 2, { -0.002, 2.324, 0.0, 0.0, 0.0, 0.0} },
 			{"Toluene", 2, { -0.243e-2, 2.43975, 0.0, 0.0, 0.0, 0.0} },
 			{"Ethanol", 2, { -0.15166, 28.2314, -0.006, 4.3667, -3.595091575e-12, 2.32936738e-10 } },
 			{"Methanol", 2, { -0.199429, 37.7823, -0.022286, 6.1238095, -1.111057e-12, 7.950186e-11} },
  			{"Water(Kaatze)",  -1, { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0} },	/* not use parameters in this array */
  			{"Ethanol2",  -1, { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0} },	/* not use parameters in this array */
  			{"Propanol",  -1, { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0} },	/* not use parameters in this array */
			
};
#else
extern StandardParam StdP[];
#endif


// functions
SCOPE complex<double> STD_Calc(double w, double t, short index);


#undef SCOPE

#endif // STDE_H_INCLUDED
