// KWWXFUNC.h -- equates for KWWXFUNC XOP

// KWWXFUNC custom error codes
#define REQUIRES_SP_OR_DP_WAVE 1 + FIRST_XOP_ERR
#define ILLEGAL_LEGENDRE_INPUTS 2 + FIRST_XOP_ERR


struct DPComplexNum {
    double real;
    double imag;
};

#pragma pack(2)
struct XFUNCKWWParams  {
    double beta;
    double logwt;
    struct DPComplexNum result;                // Complex result
};
typedef struct XFUNCKWWParams XFUNCKWWParams;
#pragma pack()

// Prototypes
HOST_IMPORT int XOPMain(IORecHandle ioRecHandle);
extern void CalcKWW(double logwt, double beta, double *rpart, double *ipart);
extern int XFUNCKWW(XFUNCKWWParams* p);

