#include "XOPStandardHeaders.r"

resource 'vers' (1) {						/* XOP version info */
	0x01, 0x01, final, 0x00, 0,				/* version bytes and country integer */
	"1.01",
	"1.01, Copyright 1993-2013 WaveMetrics, Inc., all rights reserved."
};

resource 'vers' (2) {						/* Igor version info */
	0x06, 0x20, release, 0x00, 0,			/* version bytes and country integer */
	"6.20",
	"(for Igor 6.20 or later)"
};

resource 'STR#' (1100) {					/* custom error messages */
	{
		/* [1] */
		"KWWXFUNC requires Igor 6.20 or later",
	}
};

/* no menu item */

resource 'XOPI' (1100) {
	XOP_VERSION,							// XOP protocol version.
	DEV_SYS_CODE,							// Code for development system used to make XOP
	XOP_FEATURE_FLAGS,						// Tells Igor about XOP features
	XOPI_RESERVED,							// Reserved - must be zero.
	XOP_TOOLKIT_VERSION,					// XOP Toolkit version.
};

resource 'XOPF' (1100) {
	{
		/* KWW relaxation function */
		"nKWW",							    /* function name */
		F_CMPLX | F_EXTERNAL,				/* function category == external */
		NT_FP64 | NT_CMPLX,					/* return value type */
		{
			NT_FP64,			            /* double precision wave (coefficient wave) */
			NT_FP64,						/* double precision x */
		},

	}
};
